//
//  MCMergeTokenTextView.h
//  TokenMergeTest
//
//  Created by Alykhan Jetha on 28/10/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCMergeTokenAttachment;

@interface MCMergeTokenTextView : NSTextView {
	int dragTokenCharacterIndex;
}

- (NSDictionary *)attributesForSelectedRange;
- (NSDictionary *)attributesWithoutAttachmentForSelectedRange;


- (unsigned)dragTokenCharacterIndex;
- (void)setDragTokenCharacterIndex:(unsigned)aDragTokenCharacterIndex;

- (NSAttributedString *)attributedStringFromDragTokenCharacterIndex;

- (void)insertTokenWithAttachment:(MCMergeTokenAttachment *)attach;
- (void)insertTokenWithKeyPath:(NSString *)aKeyPath label:(NSString *)aLabel;
- (void)insertTokenWithKeyPath:(NSString *)aKeyPath label:(NSString *)aLabel processorClassName:(NSString *)aClassName;
- (MCMergeTokenAttachment *)insertTokenWithKeyPath:(NSString *)aKeyPath 
											 label:(NSString *)aLabel 
								processorClassName:(NSString *)aClassName 
									 formatterCode:(int)aFormatterCode 
									  formatString:(NSString *)aFormatString;

- (IBAction)insertToken:(id)sender;

- (IBAction)mergeTokens:(id)sender;

@end
